#!/usr/bin/env python

#############################################################################
## 
#  \file host.py
#  \brief Host call mechanism implementation
#  \version 0.1
#  \author Dimitri Denk
#  \date 23.03.2016
#
# This file is a simple implementation of python based wabserver (tornado) with 
# supporting of direct python methods calls from javascript on client side.
#
# Copyright (c) 2016 
# Dimitri Denk
#
# Permission to use, copy, modify, distribute and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear
# in supporting documentation. Author makes no representations about 
# the suitability of this software for any purpose. 
# It is provided "as is" without express or implied warranty.
#
# The host call mechanism is implemented using GET method with two parameters.
# The first parameter "method" defines python function on host site.
# The second parameter "arguments" contains list of arguments and its values
# in json format.
# The result of operation is a response - text content in json format too.
#
# This example converts json input into python dictionary structure, makes
# direct call of python method (if it exists) and transforms call results
# back into json output.
#
# Notes for own python method implementation:
# The returned values must be represented in dictionary format and has always
# "result" field. If "result" not equal 0, the "error" string are mandatory.
# Other values are function implementation depended and can be free added
# to response structure.
#
# For installing of tornado module under debian/ubuntu use:
# sudo apt-get install python-tornado
#
# The "byteify" function was get from here:
# http://stackoverflow.com/questions/956867/how-to-get-string-objects-instead-of-unicode-ones-from-json-in-python/13105359#13105359
# It needs to convert json module output from unicode string to byte string.
#
#############################################################################

import tornado.httpserver
import tornado.web
from tornado.escape import json_encode, json_decode

# External variable to store actual state
SwitchState = 0

def byteify(input):
    if isinstance(input, dict):
        return {byteify(key): byteify(value)
                for key, value in input.iteritems()}
    elif isinstance(input, list):
        return [byteify(element) for element in input]
    elif isinstance(input, unicode):
        return input.encode('utf-8')
    else:
        return input

class HostCallHandler(tornado.web.RequestHandler):

	# Get method implementation
	def get(self):
		method = self.get_argument("method", default = None)
		arguments = self.get_argument("arguments", default = None)
		if method != None:
			if arguments != None:
				args = byteify(json_decode(arguments))
			else:
				args = {}
			try:
				print "calling:", method, "with", args
				if hasattr(self, method):
					result = getattr(self, method)(**args)
					resp = json_encode(result)
				else:
					resp = {"result" : -1, "error" : "method not exists"}
			except:
				resp = {"result" : -1, "error" : "execution exception"}
		else:
			resp = {"result" : -1, "error" : "method not defined"}
		print "result", resp
		self.finish(resp)

	# User function 1
	def setValue(self, slave = None, value = None):
		if value == None:
			return { "result" : -1, "error" : "value is not set" }
		elif int(value) in [0, 1]:
			global SwitchState
			SwitchState = int(value)
			return { "result" : 0 }
		else:
			return { "result" : -2, "error" : "unexpected value " + str(value) }
	
	# User function 2
	def getValue(self):
		global SwitchState
		return { "result" : 0, "value" : SwitchState }

##
# Main handler class
#
class MainHandler(tornado.web.RequestHandler):
	""" Print message to STDOUT
	@param msg The message to be printed.
	"""
	def get(self):
		self.redirect("static/test.html")

if __name__ == "__main__":
	print "starting web server..."
	application = tornado.web.Application([
		(r'/static/(.*)', tornado.web.StaticFileHandler, {'path': './'}),
		(r"/call", HostCallHandler),
		(r"/", MainHandler),
	])
	# Create server object
	http_server = tornado.httpserver.HTTPServer(application)
	# Set port to 20080
	http_server.listen(20080)
	# Starting server LOOP
	tornado.ioloop.IOLoop.instance().start()

