#############################################################################
## 
#  \file gatedrivers.py
#  \brief MOSFET gate driver specifications
#  \version 0.1
#  \author Dimitri Denk
#  \date 11.10.2016
#
# This file contains MOSFET gate driver parameters desired for
# calculation script.
#
# Last modification: 18.10.2016
# 
# Copyright (c) 2016
# Dimitri Denk
#
# Permission to use, copy, modify, distribute and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and
# that both that copyright notice and this permission notice appear
# in supporting documentation. Author makes no representations about 
# the suitability of this software for any purpose. 
# It is provided "as is" without express or implied warranty.
#
#############################################################################

# Gate drivers
NCP81074A = {
	"Name" : "NCP81074A",
	"Roh" : 0.4,		# Output resistance, High
	"Rol" : 0.4,		# Output resistance, Low
	"Imax" : 7.,		# "This driver can deliver a 7A peak current at the Miller plateau region..."
}

TC4422 = {
	"Name" : "TC4422",
	"Roh" : 1.4,		# Output resistance, High
	"Rol" : 0.9,		# Output resistance, Low
	"Imax" : 9.,
}

UCC27322 = {
	"Name" : "UCC27322",
	"Roh" : 1.5,		# Output resistance, High
	"Rol" : 1.1,		# Output resistance, Low
	"Imax" : 9.,
}

IdealDriver = {
	"Name" : "Ideal 25A",
	"Roh" : 0.,			# Output resistance, High
	"Rol" : 0.,			# Output resistance, Low
	"Imax" : 25.,
}
