##############################################################################
## 
#  \file dtidev.py
#  \brief DTI device.
#  \version 0.2
#  \author Dimitri Denk
#  \date 12.08.2011
#
#  This file provides DTI device communication functions.
#
#  Copyright (c) 2010-2011
#  DENKTECH
#  www.denktech.de
#
#  Permission to use, copy, modify, distribute and sell this software
#  and its documentation for any purpose is hereby granted without fee,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear
#  in supdeving documentation. DENKTECH makes no representations about 
#  the suitability of this software for any purpose. 
#  It is provided "as is" without express or implied warranty.
#
##############################################################################

##
# \addtogroup DTI_DEVICE DTI device
# \ingroup DTI_TOOLS
#
# Python scripts for DTI interferometers
#
# @{

import dtcam
import dtmath
from math import ceil, pi as PI
from numpy import float64
import time

cport = dtcam.cam(ip = "192.168.0.32", port = 80)

## Get frame with phase shifting
#  
#  This function captures one frame with desired phase shifting
#
#  \param shift - normalized PZT voltage, float in range from 0. to 1. or None.
#  If shift is None, function will capture frame without phase shifting.
#  \param verb - verbose output, boolean
#  \retval frame - image, numpy uint16 array
def get_frame(shift, verb = False):

	if shift != None:
		f = cport.get_frame("/img.pgm?shift=" + str(int(shift * 32768)))
	else:
		f = cport.get_frame("/img.pgm")
	return f

## Get phase map from device
#  
#  This function gets phase map using device build-in phase calculation
#  algorithm
#
#  \param ref - reference points for phase shifting, list of floats in range
#  from 0. to 1.
#  \param verb - verbose output, boolean
#  \retval phase - phase map, numpy float64 array
def get_phase(ref, verb = False):

	# prepare uri
	uri = "/phase.pgm?"
	for i in xrange(len(ref)):
		if i > 0:
			uri = uri + "&"
		uri = uri + "shift=" + str(int(ref[i] * 32768))
	if verb:
		print "uri: " + str(uri)

	#get phase
	p = cport.get_frame(uri)
	p = float64(PI - (p * PI / 32768))

	return p

##
# @}

# EOF

