##############################################################################
## 
#  \file utils.py
#  \brief IAPACK utils.
#  \version 0.2
#  \author Dimitri Denk
#  \date 12.08.2011
#
#  This file provides various helper functions
#
#  Copyright (c) 2010-2011
#  DENKTECH
#  http://www.denktech.de
#
#  Permission to use, copy, modify, distribute and sell this software
#  and its documentation for any purpose is hereby granted without fee,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear
#  in supporting documentation. DENKTECH makes no representations about 
#  the suitability of this software for any purpose. 
#  It is provided "as is" without express or implied warranty.
#
#############################################################################

##
# \addtogroup DTI_SCRIPTS scripts
# \ingroup DTI_TOOLS
#
# Python scripts for DTI interferometers
#
# @{

## Save array in csv format
#
#  \param fname - file name, string
#  \param data - data to be saved, numpy array, list or tupple
def save_csv(fname: str, data) -> None:
	save_txt(fname, data, '; ')


## Save array in text format
#
#  \param fname - file name, string
#  \param data - data to be saved, numpy array, list or tupple
#  \param separator - data to be saved, numpy array, list or tupple
def save_txt(fname: str, data, separator: str = '\t') -> None:
	f = open(fname, "wt")
	for i in range( len(data) ):
		v = data[i]
		if type(v) in (list, tuple):
			l = len(v)
			for j in range( l ):
				f.write(str(v[j]))
				if j < l - 1:
					f.write(separator)
		else:
			f.write(str(v))
		f.write('\n')
	f.close()


def smooth(mask, opd, verb):
	from scipy import ndimage
	from numpy import ma
	merror = ma.masked_where(mask is False, opd)
	res = ndimage.gaussian_filter(merror, 7.)
#	res = merror
#	error = merror.__array__() * mask
	return res.__array__() * mask
#	return opd

# @}

# EOF

