%****************************************************************************
%
%  \file test.m
%  \brief Matlab image capture library for DTI interferometers
%  \version 0.3
%  \author Dimitri Denk
%  \date 02.02.2011
%
%  This file implements simple test of library.
% 
%  Copyright (c) 2011 
%  DENKTECH
%  www.denktech.de
% 
%  Permission to use, copy, modify, distribute and sell this software
%  and its documentation for any purpose is hereby granted without fee,
%  provided that the above copyright notice appear in all copies and
%  that both that copyright notice and this permission notice appear
%  in supporting documentation. DENKTECH makes no representations about 
%  the suitability of this software for any purpose. 
%  It is provided "as is" without express or implied warranty.
%
%****************************************************************************

clear;

% set device address
dtcam(uint8(0), uint8([192,168,0,32]), uint16(80));

% get image
z = dtcam(uint8(1));

% get image with phase shift 0
z = dtcam(uint8(1), int16(0));

% get phase map
ref = int16([ 0., 0.21214471, 0.37421732, 0.53773306, 0.70740915] * 32768);
z = dtcam(uint8(2), ref);
	
% plot result
z = uint8(z / 256);
image(z)
colormap(jet(256))
axis off
axis image

