from distutils.core import setup, Extension
import sys

MAJOR_VERSION = 0
MINOR_VERSION = 3

if sys.platform == "win32":
	print "WIN32"
	include_dirs = ['../libdtcam', 'C:/Python26/Lib/site-packages/numpy/core/include',]
	libraries = ['dtcam', 'wsock32',]
else:
	print "LINUX"
	include_dirs = '../libdtcam',
	libraries = ['dtcam',]

module1 = Extension(
	'dtcam',
	define_macros = [('MAJOR_VERSION', MAJOR_VERSION), ('MINOR_VERSION', MINOR_VERSION) ],
	include_dirs = include_dirs,
	libraries = libraries,
	library_dirs = ['../libdtcam'],
	sources = [
		'dtcam.c',
		]
	)

setup(
	name = 'dtcam',
	version = str(MAJOR_VERSION) + "." + str(MINOR_VERSION),
	description = 'dtcam package',
	author = 'Dimitri Denk',
	author_email = 'dimitri.denk@denktech.de',
	url = 'http://www.denktech.de/',
	long_description = '''
DTI module camera supprot package.
''',
	ext_modules = [module1],
	)
    
